/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Months;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class YearClockParameter
extends ProtectionParameter {
    static final long serialVersionUID = 0L;
    private int yearClockParameterSerializedDataVersion = 3;
    protected Months fOnTime;
    protected Months fOffTime;
    private final int MAX_YEAR = 2099;
    private final int MIN_YEAR = 2000;
    protected int fStartYear = 2000;
    protected int fEndYear = 2099;
    protected boolean fYearly = false;
    protected boolean fPulse = false;
    private transient boolean fPreState;

    public YearClockParameter() {
    }

    public int getYearStart() {
        return 2000;
    }

    public String getParameterText() {
        StringBuffer ret = new StringBuffer();
        ret.append("YY:").append(this.fOnTime.getUnitAbbreviation()).append("\nOn=").append(this.getYearString(this.fStartYear)).append(":").append(this.fOnTime.getParameterText()).append(this.getProtectionSign()).append("\nOff=").append(this.getYearString(this.fEndYear)).append(":").append(this.fOffTime.getParameterText());
        if (this.getBlock().getHardware().supports("yearRangePulseYearClock")) {
            ret.append("\nYearly=").append(this.fYearly ? "Y" : "N").append("\nPulse=").append(this.fPulse ? "Y" : "N");
        }
        return ret.toString();
    }

    private String getYearString(int year) {
        String preStr = "" + year % 100;
        return "00".substring(preStr.length()) + preStr;
    }

    public YearClockParameter(Block block) {
        super(block);
        this.fParameter = 2;
        this.fData = 0;
        this.fAllocatedTimer = 0;
        this.fOnTime = new Months();
        this.fOffTime = new Months();
        this.fStartYear = 2000;
        this.fEndYear = 2099;
        this.fYearly = true;
        this.setParameterNameKeys();
    }

    public String calculateCurrentParameterText() {
        return DateFormat.getDateInstance(2, Language.getLocale()).format(new Date(this.fInterpreter.getCurrentSimulationClockTime()));
    }

    public Months getOffTime() {
        if (this.fOffTime == null) {
            this.fOffTime = new Months();
        }
        return this.fOffTime;
    }

    public void setOffTime(Months months) {
        this.fOffTime = months;
    }

    public Months getOnTime() {
        if (this.fOnTime == null) {
            this.fOnTime = new Months();
        }
        return this.fOnTime;
    }

    public void setOnTime(Months months) {
        this.fOnTime = months;
    }

    public final boolean getValue() {
        boolean state = false;
        Date today = new Date(this.fInterpreter.getCurrentSimulationClockTime());
        if (this.fPulse) {
            state = this.isPulseOnDay(today);
            boolean risingEdge = state && !this.fPreState;
            this.fPreState = state;
            state = risingEdge;
        } else {
            state = this.getBlock().getWiringDiagram().getHardware().supports("yearRangePulseYearClock") ? this.getValueWithAddtionalSettings(today) : this.getValueYearlyForEver(today);
        }
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return state;
    }

    private boolean isPulseOnDay(Date today) {
        boolean ret = true;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(today);
        int todayYear = today.getYear() + 1900;
        ret = this.fYearly ? (ret &= todayYear >= this.fStartYear && todayYear <= this.fEndYear) : (ret &= todayYear == this.fStartYear);
        if (!this.isEveryMonth()) {
            ret &= this.fOnTime.getHighValue() == gregorianCalendar.get(2) + 1;
        }
        return ret &= this.fOnTime.getLowValue() == gregorianCalendar.get(5);
    }

    private boolean getValueWithAddtionalSettings(Date today) {
        boolean state = false;
        state = this.isYearly() != false ? this.getValueYearlyForEver(today) && this.todayInRange(today) : this.todayInRange(today);
        return state;
    }

    private boolean todayInRange(Date today) {
        int todayYear = today.getYear() + 1900;
        Months onTime = (Months)this.fOnTime.clone();
        Months offTime = (Months)this.fOffTime.clone();
        if (this.isEveryMonth()) {
            onTime.setTime(1, this.fOnTime.getLowValue());
            offTime.setTime(12, this.fOffTime.getLowValue());
        }
        boolean laterThanStart = todayYear > this.fStartYear || todayYear == this.fStartYear && onTime.compareWith(today) <= 0;
        boolean earlierThanEnd = todayYear < this.fEndYear || todayYear == this.fEndYear && offTime.compareWith(today) > 0;
        return laterThanStart && earlierThanEnd;
    }

    private boolean getValueYearlyForEver(Date today) {
        boolean state = true;
        if (this.isEveryMonth()) {
            int onDay = this.fOnTime.getLowValue();
            int offDay = this.fOffTime.getLowValue();
            int todayDay = today.getDate();
            if (onDay < offDay) {
                if (onDay > todayDay || offDay <= todayDay) {
                    state = false;
                }
            } else if (onDay == offDay) {
                state = false;
            } else if (onDay > todayDay && offDay <= todayDay) {
                state = false;
            }
        } else {
            switch (this.fOnTime.compare(this.fOffTime)) {
                case -1: {
                    if (this.fOnTime.compareWith(today) <= 0 && this.fOffTime.compareWith(today) > 0) break;
                    state = false;
                    break;
                }
                case 0: {
                    state = false;
                    break;
                }
                case 1: {
                    if (this.fOnTime.compareWith(today) <= 0 || this.fOffTime.compareWith(today) > 0) break;
                    state = false;
                }
            }
        }
        return state;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fOnTime = (Months)dr.readStorable();
        this.fOffTime = (Months)dr.readStorable();
        this.fPulse = dr.readBoolean();
        this.fYearly = dr.readBoolean();
        this.fStartYear = dr.readInt();
        this.fEndYear = dr.readInt();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (Global.latestFileCreaterVersion < 6 && this.yearClockParameterSerializedDataVersion >= 3) {
            this.yearClockParameterSerializedDataVersion = 2;
        }
        if (this.yearClockParameterSerializedDataVersion == 1) {
            this.setParameterNameKeys();
            this.yearClockParameterSerializedDataVersion = 2;
        }
        if (this.yearClockParameterSerializedDataVersion == 2) {
            this.fStartYear = 2000;
            this.fEndYear = 2099;
            this.fYearly = true;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.yearClockParameterSerializedDataVersion = 3;
        s.defaultWriteObject();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fOnTime);
        dw.writeStorable(this.fOffTime);
        dw.writeBoolean(this.fPulse);
        dw.writeBoolean(this.fYearly);
        dw.writeInt(this.fStartYear);
        dw.writeInt(this.fEndYear);
    }

    public boolean isEveryMonth() {
        return this.getOnTime().isEveryMonth();
    }

    public void setEveryMonth(boolean everyMonth) {
        this.getOnTime().setEveryMonth(everyMonth);
        this.getOffTime().setEveryMonth(everyMonth);
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        boolean result = super.isAvailable(hardware, errorList);
        if (this.isEveryMonth() && !hardware.supports("yearClockEveryDay")) {
            errorList.add(new ErrorInfo(this, "error.convert.yearClock.everyMonth", hardware));
            result = false;
        }
        if (!hardware.supports("yearRangePulseYearClock")) {
            if (this.getPulse().booleanValue()) {
                errorList.add(new ErrorInfo(this, "error.convert.yearClock.pulse", hardware));
                result = false;
            }
            if (!this.isYearly().booleanValue()) {
                errorList.add(new ErrorInfo(this, "error.convert.yearClock.yearly", hardware));
                result = false;
            }
            if (this.fStartYear != 2000 || this.fEndYear != 2099) {
                errorList.add(new ErrorInfo(this, "error.convert.yearClock.yearRange", hardware));
                result = false;
            }
        }
        return result;
    }

    public Boolean getPulse() {
        return this.fPulse;
    }

    public void setPulse(Boolean pulse) {
        this.fPulse = pulse;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fPreState = true;
    }

    public IntValueProperties getOnYear() {
        return new IntValueProperties(2000, 2099, 1, this.fStartYear, "error.dialog.invalidValue", "Invalid Value.");
    }

    public IntValueProperties getOffYear() {
        return new IntValueProperties(2000, 2099, 1, this.fEndYear, "error.dialog.invalidValue", "Invalid Value.");
    }

    public Boolean isYearly() {
        return this.fYearly;
    }

    public void setYearly(Boolean yearly) {
        this.fYearly = yearly;
    }

    public void setOnYear(IntValueProperties value) {
        this.fStartYear = value.getCurrentValue();
    }

    public void setOffYear(IntValueProperties value) {
        this.fEndYear = value.getCurrentValue();
    }

    public void setOnYear(int value) {
        this.fStartYear = value;
    }

    public void setOffYear(int value) {
        this.fEndYear = value;
    }
}

